#COMMENTS-START
Portable App Creator was written by maroesjk (nickname of Ren Dijkmans)
Please see the 'readme.pdf' file for general and/or copyright information

Package version:				0972 beta
Last changes in this script:	15 October 2008
#COMMENTS-END

#NoTrayIcon
#RequireAdmin

$ScriptProcesses = ProcessList(@ScriptName)																			;Get ProcessList for the script
If $ScriptProcesses[0][0] > 1 Then Exit(MsgBox(16, 'Error', 'Only one instance of "' & @ScriptName & '" allowed.'))	;If more than one instance display error and exit the script
If FileExists(@ScriptDir & '\PAC Compiler.exe') Then Exit(FileDelete(@ScriptDir & '\PAC Compiler.exe'))

;BEGIN SET OPTIONS AND DEFINING VARIABLES 
AutoItSetOption	('OnExitFunc', 	'ClosePAC')
EnvSet			('system32', 	@SystemDir)
Global	$EnvArray[5]	= [4, 'system32', 'allusersprofile', 'userprofile', 'commonprogramfiles'], $EnvGetAr[5]	= [4, EnvGet($EnvArray[1]), EnvGet($EnvArray[2]), EnvGet($EnvArray[3]), EnvGet($EnvArray[4])], _
		$SkipFolder[8]	= [7, @StartMenuCommonDir, @StartMenuDir, @DesktopCommonDir, @DesktopDir, @UserProfileDir & '\Recent', @UserProfileDir & '\Local Settings\Temporary Internet Files', '\temp\'], _
		$RegTypes[11]	= ['REG_NONE', 'REG_SZ', 'REG_EXPAND_SZ', 'REG_BINARY', 'REG_DWORD', 'REG_DWORD_BIG_ENDIAN', 'REG_LINK', 'REG_MULTI_SZ', 'REG_RESOURCE_LIST', 'REG_FULL_RESOURCE_DESCRIPTOR', 'REG_RESOURCE_REQUIREMENTS_LIST'], _
		$SkipRegKey[12] = [11, 'RecentDocs', 'MUICache', 'OpenSaveMRU', 'StreamMRU', 'MenuOrder', 'ShellNoRoam', 'Setup', 'Uninstall', 'Cache', 'UserAssist', 'Discardable'], _
		$GUI_ENABLE 	= 64, $GUI_DISABLE = 128, $GUI_ENABLE_FOCUS = 320, $GUI_ENABLE_DEFBUTTON = 576, $GUI_EVENT_CLOSE = -3, $GUI_CHECKED = 1, $OSVersion = StringReplace(StringReplace(@OSVersion, 'VISTA', 'Vista'), 'WIN_', ''), _
		$Temp			= @TempDir & '\PAC', $RegFile = $Temp & '\portableapp.reg', $LstFile = $Temp & '\portableapp.lst', $IniFile = $Temp & '\portableapp.ini', $ResFile = $Temp & '\~res.txt', $RegShotIni = $Temp & '\regshot.ini', $AltIcon = $Temp & '\portable app creator.ico', $SelectedIcon = $AltIcon, $RegShotTitle = 'Regshot', _
		$GUI, $Back, $Next, $Skip, $Cancel, $ApplicationValue, $SetupValue, $MonitorInstallation, $CurrentButton, $InfoTip, $Picture, $Header, $LauncherValue, $LauncherName, $LauncherFolder, $Info, $PADrive = StringLeft(@ScriptDir, 2), $ButtonArray[7], $CompressApp = 1, $CompileDate = FileGetTime(@ScriptFullPath), $DriveList, $aEN[1]
;END SET OPTIONS AND DEFINING VARIABLES 

;MAIN PROGRAM
DirRemove($Temp, 1)
DirCreate($Temp)
CreateGUI()
Welcome()
;END MAIN PROGRAM

Func CreateGUI()							;CREATE STANDARD PART OF THE GUI
						  FileInstall('..\..\app\appfiles\line.jpg',	$Temp & '\')
						  FileInstall('..\..\app\appfiles\picture.jpg',	$Temp & '\')
						  FileInstall('..\..\app\appinfo\gui.ico',		$Temp & '\')
	$GUI				= GUICreate	 ('', 442, 298, (@DesktopWidth - 442) / 2, (@DesktopHeight - 298) / 2 - 20)		;Create the GUI
	$Cancel				= GUICtrlCreateButton	('Cancel',						357, 262,  73,  23,   0)			;Create the Cancel button
						  GUICtrlSetOnEvent		($Cancel, 'ClosePAC')												;Sets Cancel to go to ClosePAC()	
	$InfoTip 			= GUICtrlCreateIcon		(@WindowsDir & '\explorer.exe', 109,  10, 265,  16,  16)			;Create InfoTip icon
						  GUICtrlCreatePic		($Temp & '\line.jpg',			  0, 250, 442,   2)					;Create GUI line
	$Picture			= GUICtrlCreatePic		($Temp & '\picture.jpg',		  0,   0, 132, 250)					;Create GUI image
						  GUISetIcon			($Temp & '\gui.ico')												;Set the icon
						  HotKeySet				('{F1}', 'Help')													;Set Help
						  GUISetState()																				;Show the GUI
EndFunc

Func ClearGUI($GUITitle)					;CLEARS THE GUI AND SETS THE NEW TITLE
	WinSetTitle($GUI, '', 'Portable App Creator - ' & $GUITitle)													;Set the new title of the GUI
	For $i = $Picture + 1 to 99
		If Not GUICtrlDelete($i) Then ExitLoop																		;Clear all controls created after CreateGUI()
	Next
	$Back				= GUICtrlCreateButton	('< &Back',		107, 262, 73, 23, 0)								;Create the Back button
	$Next				= GUICtrlCreateButton	('&Next >',		195, 262, 73, 23, 0)								;Create the Next button
	$Skip				= GUICtrlCreateButton	('&Skip >>',	269, 262, 73, 23, 0)								;Create the Skip button	
EndFunc

Func Welcome()								;GETS INFO ON APPLICATION TO INSTALL
	ClearGUI			 ('Welcome')																				;Clears the GUI and sets the new title
	GUICtrlSetFont		 (GUICtrlCreateLabel	('Welcome to Portable App Creator', 150, 13, 280, 13),	-1, 800)	;Show line of bold text
	GUICtrlCreateLabel	 ('Portable App Creator (PAC) can monitor an installation for you. The speed of ' & _		;Show lines of text
		'monitoring an installation depends on the speed of your PC, the size of the registry and the number of files in some specific folders on the PC.' & @CRLF & @CRLF & 'It is strongly recommended that you exit all Windows programs before running PAC.', 150, 28, 280, 91)
	GUICtrlSetFont		(GUICtrlCreateLabel		('Info',							150, 150, 280, 13),	-1, 800)	;Show line of bold text	
	$Info				= GUICtrlCreateLabel('PAC assumes that you want to monitor the installation of ' & _
		'software to the portable device located at drive ' & $PADrive & '\. If that is not the drive to use please, please change it.',	150, 165, 280, 39)
	$DriveArray		= DriveGetDrive('ALL')																			;Get an array of all driveletters
	GUICtrlCreateLabel('Portable device located at drive',	150, 215, 160, 13)
	$DLCombo	= GUICtrlCreateCombo(StringUpper($DriveArray[1]), 310, 212, 40)
	For  $i 		= 2 to $DriveArray[0]
		$DriveList &= StringUpper($DriveArray[$i]) & '|'
	Next
	GUICtrlSetData		  ($DLCombo, $DriveList, $PADrive)
	GUICtrlSetState		  ($Skip, $GUI_DISABLE)																		;Disable Skip
	GUICtrlSetState		  ($Back, $GUI_DISABLE)																		;Disable Back
	GUICtrlSetState		  ($Next, $GUI_ENABLE_DEFBUTTON)															;Focus on Next
	InstallHelperFiles()																							;Go to InstallHelperFiles
	While 1
		$Control	= GUIGetMsg()																					;Get info from the GUI
		If $Control	= $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed or cancelled, exit the script
		If $Control	= $Next											Then InstallApplication()						;If Next is clicked go to InstallApplication()
		If $Control = $DLCombo										Then
			$PADrive = GUICtrlRead($DLCombo)
			GUICtrlSetData($Info, 'PAC assumes that you want to monitor the installation of software to the portable device located at drive ' & $PADrive & '\. If that is not the drive to use please, please change it.')
		EndIf
	Wend
EndFunc

Func InstallApplication()					;GETS INFO ON APPLICATION TO INSTALL
	ClearGUI			  ('Install Application')
	$SetupLabel		= 0 * (GUICtrlCreateInput('', 150, 77, 200, 21) & GUICtrlSetState(-1, $GUI_DISABLE) & _			;Create SetupLabel
 		GUICtrlSETBKColor(-1, 0xFFFFFF)) + GUICtrlCreateLabel($SetupValue, 153, 80, 194, 17, 0x5000010B) + 0 * GUICtrlSetBKColor(-1, 0xFFFFFF)
	$BrowseSetup	= GUICtrlCreateButton	('B&rowse...', 357, 76, 73, 23, 0)										;Create BrowseSetup
					  GUICtrlCreateLabel	  ('This wizard helps you to install an application to drive ' & _		;Show lines of text
		$PADrive & '.', 150, 13, 280, 13)
					  GUICtrlCreateLabel	('Get the location of the software to install:', 150, 60, 280, 13)		;Show line of text
	$Compress		= GUICtrlCreateCheckbox ('Compress the software using UPX.', 150, 224, 280, 13)					;Show the checkbox to compress the application
	If $CompressApp Then GUICtrlSetState($Compress, 1)																;Check the box if wanted
	If Not $SetupValue Then GUICtrlSetState($Next, $GUI_DISABLE)													;Disable NextButton if InputSetupValue is empty
	GUICtrlSetState		  ($BrowseSetup, $GUI_ENABLE_FOCUS)															;Focus on InputSetup
	While 1
		$Control	= GUIGetMsg()																					;Get info from the GUI
		If $Control	= $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed or cancelled, exit the script
		If $Control	= $Back											Then Welcome()									;If Back is clicked go to Welcome()
		If $Control	= $Next											Then											;If Next is clicked
			$MonitorInstallation = True																				;Set the variable to test if an installation has to be monitored to 'true'
			$CurrentButton = 0
			If ($OSVersion = 'Vista' And RegRead('HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System', _;Display error if running on Vista and UAC is enabled or the OS is 64-bit
				'EnableLUA') = '1') Or StringRight(@ProcessorArch, 2) = '64' Then RegShotError()					;Mental note: @ProcessorArch actually gives the architecture of the OS!
			If ControlCommand($RegShotTitle, '', 1006, 'IsEnabled') Then ControlSend($RegShotTitle, '', 1006, 'cc')	;Clear any old regshot data
			MonitorInstallation()																					;Go to MonitorInstallation()
		EndIf
		If $Control	= $Skip											Then											;If Skip is clicked
			$MonitorInstallation = False																			;Set the variable to test if an installation has to be monitored to 'false'
			GetShortCutInfo()																						;Go to GetShortCutInfo()
		EndIf

		If $Control	= $BrowseSetup Or $Control = $SetupLabel 		Then											;If BrowseSetup is clicked
			$SetupValue	= FileOpenDialog('Portable App Creator (Install Application)', '', _						;Open a filedialog to get the package to run
				'Setup Packages (*.exe;*.com;*.bat;*.msi)', 1)
			If $SetupValue Then																						;If a file has been selected
				GUICtrlSetData($SetupLabel,	$SetupValue)															;Put its name in the box
				GUICtrlSetState($Next, $GUI_ENABLE_DEFBUTTON)														;Enable NextButton and give it Focus
			EndIf
		EndIf
		If $Control = $Compress										Then
			If GUICtrlRead($Compress) = 1 Then $CompressApp = 1														;If the state is   checked then $CompressApp is 1
			If GUICtrlRead($Compress) = 4 Then $CompressApp = 0														;If the state is unchecked then $CompressApp is 0
		EndIf
	Wend
EndFunc

Func GetShortCutInfo()						;GETS INFO ON THE SHORTCUT TO CREATE
	ClearGUI			  ('ShortCut Information')																	;Clears the GUI and sets the new title
	GUICtrlCreateLabel	  ('This wizard helps you to create a launcher to an application on your portable ' & _		;Show lines of text
		'device (' & $PADrive & ').', 150, 13, 280, 26)
	GUICtrlCreateLabel	  ('Get the location of the application to run:',					150,  60, 280, 13)		;Show line of text
	GUICtrlCreateLabel	  ('Get the location for the launcher:',							150, 110, 280, 13)		;Show line of text
	$ApplicationLabel	= 0 * (GUICtrlCreateInput('', 150, 77, 200, 21) & GUICtrlSetState(-1, $GUI_DISABLE) & _		;Create ApplicationLabel
 		GUICtrlSETBKColor(-1, 0xFFFFFF)) + GUICtrlCreateLabel($ApplicationValue, 153,  80, 194, 17, 0x5000010B) + 0 * GUICtrlSetBKColor(-1, 0xFFFFFF)
	$LauncherLabel		= 0 * (GUICtrlCreateInput('', 150, 127, 200, 21) & GUICtrlSetState(-1, $GUI_DISABLE) & _	;Create LauncherLabel
		GUICtrlSETBKColor(-1, 0xFFFFFF)) + GUICtrlCreateLabel($LauncherValue,    153, 130, 194, 17, 0x5000010B) + 0 * GUICtrlSetBKColor(-1, 0xFFFFFF)
	$BrowseApplication	= GUICtrlCreateButton	('B&rowse...',								357,  76,  73, 23, 0)	;Create BrowseApplication
	$BrowseLauncher		= GUICtrlCreateButton	('Browse...',								357, 126,  73, 23, 0)	;Create BrowseIcon
	$AppIconRadio		= GUICtrlCreateRadio	('Use the icon of the application to run', 	150, 165, 200, 13)		;Create AppIconRadio
    $AltIconRadio		= GUICtrlCreateRadio	("Use alternative icon", 					150, 180, 200, 13)		;Create AltIconRadio
	$BrowseIcon			= GUICtrlCreateButton	('Browse...',								357, 175,  73, 23, 0)	;Create BrowseIcon
	$ShowIcon			= GUICtrlCreateIcon		($SelectedIcon, '',							377, 205)				;Create Icon Preview
	GUICtrlSetState		($AppIconRadio,		$GUI_DISABLE)															;Disable AppIconRadio
	GUICtrlSetState		($AltIconRadio,		$GUI_CHECKED)															;Disable AltIconRadio
	If Not $MonitorInstallation Then GUICtrlSetData($Next, '&Finish')												;Change text on NextButton if no installation has to be monitored
	If 	   $MonitorInstallation Then GUICtrlSetFont(GUICtrlCreateLabel('Please install any service pack, patch,' & _;Remind the user!
		' hotfix, update or add-on before continuing.', 150, 213, 200, 24), 7)
	If Not $ApplicationValue Then GUICtrlSetState($Next, $GUI_DISABLE)												;Disable NextButton if no Launchervalue was entered
	GUICtrlSetState		  ($Skip, $GUI_DISABLE)																		;Disable SkipButton
	GUICtrlSetState		  ($BrowseApplication, $GUI_ENABLE_DEFBUTTON)												;Focus on InputApplication
	While 1
		$Control	= GUIGetMsg()																					;Get info from the GUI
		If $Control	= $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed or cancelled, exit the script
		If $Control	= $Back And $MonitorInstallation				Then											;If Back is clicked and an installation has to be monitored
			$CurrentButton = 2
			MonitorInstallation()																					;Go to MonitorInstallation()
		EndIf
		If $Control	= $Back And Not $MonitorInstallation			Then InstallApplication()						;If Back is clicked and no installation has to be monitored go to InstallApplication()
		If $Control	= $Next And $MonitorInstallation				Then											;If Next is clicked and an installation has to be monitored
			$CurrentButton = 3
			MonitorInstallation()																					;Go to MonitorInstallation()
		EndIf
		If $Control	= $Next And Not $MonitorInstallation			Then CreateShortCut()							;If Next is clicked and no installation has to be monitored go to CreateShortCut()
		If $Control	= $BrowseApplication Or _
			$Control = $ApplicationLabel							Then											;If BrowseApplication or ApplicationLabel is clicked
			If $ApplicationValue Then
				$FolderSuggest = $ApplicationValue
			ElseIf $LauncherValue Then 
				$FolderSuggest = $LauncherValue
			Else
				$FolderSuggest = $PADrive
			EndIf
			$ApplicationValue = FileOpenDialog('Portable App Creator - Run Application', $FolderSuggest, _			;Open a filedialog to get the application to run
				'Executable Files (*.exe;*.com;*.bat)|All Files (*.*)', 1)
			If $ApplicationValue Then																				;If a file has been selected
				GUICtrlSetData($ApplicationLabel, $ApplicationValue)												;Put its name in the box
				If FirstIconToFile($ApplicationValue, $Temp & '\AppIcon.ico') Then									;If Applicationvalue has an icon then
					GUICtrlSetState($AppIconRadio, $GUI_ENABLE)														;Enable AppIconRadio
					GUICtrlSetState($AppIconRadio, $GUI_CHECKED)													;Check AppIconRadio
					GUICtrlSetState($BrowseIcon, $GUI_DISABLE)														;Disable BrowseIcon
					GUICtrlSetImage($ShowIcon, $Temp & '\AppIcon.ico')												;Change the Icon
					$SelectedIcon = $Temp & '\AppIcon.ico'
				Else																								;If Applicationvalue has no icon then
					GUICtrlSetState($AppIconRadio, $GUI_DISABLE)													;Disable AppIconRadio
					GUICtrlSetState($AltIconRadio, $GUI_CHECKED)													;Check AltIconRadio
					GUICtrlSetState($BrowseIcon, $GUI_ENABLE)														;Enable BrowseIcon
					GUICtrlSetImage($ShowIcon, $AltIcon)															;Change the Icon
					$SelectedIcon = $AltIcon
				EndIf
				If GUICtrlRead($LauncherLabel) Then GUICtrlSetState($Next, $GUI_ENABLE_DEFBUTTON)		 			;If the launcher and application are known enable Next and give it focus
			EndIf
		EndIf
		If $Control	= $BrowseLauncher Or $Control = $LauncherLabel	Then											;If BrowseLauncher or LauncherLabel is clicked
			If $LauncherValue Then
				$FolderSuggest = $LauncherValue
			ElseIf $ApplicationValue Then 
				$FolderSuggest = StringMid($ApplicationValue, 1, StringInStr($ApplicationValue, '\', 0, -2))
			Else
				$FolderSuggest = $PADrive
			EndIf
			$LauncherValue = FileSaveDialog('Portable App Creator - Save Launcher', $FolderSuggest, _				;Open a filedialog to get the launcher to save
				'Executable Files (*.exe)')
			If $LauncherValue Then	
				If Not (StringRight($LauncherValue, 4) = '.exe') Then $LauncherValue &= '.exe'						;If an exe-file has been selected
				GUICtrlSetData($LauncherLabel, $LauncherValue)														;Put its name in the box
				If GUICtrlRead($ApplicationLabel) Then GUICtrlSetState($Next, $GUI_ENABLE_DEFBUTTON)		 		;The launcher and application are known enable Next and give it focus
				$Slash			= StringInStr($LauncherValue, '\', 0, -1)
				$LauncherName	= StringMid ($LauncherValue, $Slash + 1, StringLen($LauncherValue) - $Slash - 4)
				$LauncherFolder	= StringLeft($LauncherValue, $Slash - 1)
			EndIf
		EndIf
		If $Control = $AppIconRadio									Then											;If one chooses the radiobutton for the application icon
			GUICtrlSetState($BrowseIcon, $GUI_DISABLE)																;Disable BrowseIcon
			GUICtrlSetImage($ShowIcon, $Temp & '\AppIcon.ico')														;Change the Icon
			$SelectedIcon = $Temp & '\AppIcon.ico'
		EndIf			
		If $Control = $AltIconRadio									Then 											;If one chooses the radiobutton for the alternative icon
			GUICtrlSetState($BrowseIcon, $GUI_ENABLE)																;Enable BrowseIcon
			GUICtrlSetImage($ShowIcon, $AltIcon)																	;Change the Icon		
			$SelectedIcon = $AltIcon			
		EndIf
		If $Control	= $BrowseIcon									Then											;If BrowseApplication is clicked
			$IconValue	= FileOpenDialog('Portable App Creator - ShortCut Information', $PADrive, _					;Open a filedialog to get the icon for the application
				'Icon files (*.ico)|All Files (*.*)', 1)
			If $IconValue Then $AltIcon = $IconValue																;If a file has been selected then make it the new selectedicon		
			GUICtrlSetImage($ShowIcon, $AltIcon)																	;Change the Icon
			$SelectedIcon = $AltIcon
		EndIf
	Wend
EndFunc

Func MonitorInstallation()					;MONITORS THE INSTALLATION
	ClearGUI			  ('Monitor Installation')																	;Clears the GUI and sets the new title
	GUICtrlCreateLabel	  ('This wizard helps you to monitor the installation.' & @CRLF & 'Press the ' & _			;Show lines of text
		'subsequent buttons below:', 150, 13, 280, 26)
	Global $ButtonArray[7] 	= [6, _
		GUICtrlCreateButton	('Take 1st Shot',		225, 60,  130, 23, 0), _										;Create 1st button (Take 1st Shot)
		GUICtrlCreateButton	('Install Application',	225, 90,  130, 23, 0), _										;Create 2nd button (Install Application)
		GUICtrlCreateButton	('Get Shortcut Info',	225, 120, 130, 23, 0), _										;Create 3rd button (Get Shortcut Info)
		GUICtrlCreateButton	('Open / Close',		225, 150, 130, 23, 0), _										;Create 4th button (Open / Close)
		GUICtrlCreateButton	('Take 2nd Shot',		225, 180, 130, 23, 0), _										;Create 5th button (Take 2nd Shot)
		GUICtrlCreateButton	('Process Shots', 		225, 210, 130, 23, 0)]											;Create 6th button (Process Shots)
	GUICtrlSetState	($Skip,	$GUI_DISABLE)																			;Disable SkipButton
	SetButton(True)																									;Set the buttons
	While 1
		$Control	= GUIGetMsg()																					;Get info from the GUI
		If $Control	= $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed or cancelled, then exit the script
		If $Control	= $Back And $CurrentButton < 4					Then InstallApplication()						;If Back is clicked and the currentbutton isn't Open, go to InstallApplication() 
		If $Control	= $Back And $CurrentButton = 4					Then GetShortCutInfo()							;If Back is clicked and the currentbutton is $Open, go to GetShortCutInfo() 
		If $Control	= $Next And $CurrentButton <= $ButtonArray[0] 	Then $Control = $ButtonArray[$CurrentButton]	;If Next is clicked and there are buttons to execute, execute the current button 
		If $Control	= $Next And $CurrentButton >  $ButtonArray[0] 	Then CreateShortCut()							;If Next is clicked and there are no more buttons to execute, go to CreateShortCut()
		If $Control	= $ButtonArray[1]								Then											;If 'Take 1st Shot' is clicked
			SetButton(False)																						;Set the buttons
			ControlSend($RegShotTitle, '', 1003, '1s')																;Gets first shot of the registry and files
			Do
			Until ControlCommand($RegShotTitle, '', 1004, 'IsEnabled') * Sleep(100) 								;Until the '2nd shot' button is enabled
			SetButton(True)																							;Set the buttons
		EndIf
		If $Control	= $ButtonArray[2]								Then											;If 'Install Application' is clicked
			SetButton(False)																						;Set the buttons
			ShellExecute($SetupValue)																				;Run the Setup
			WinWaitNotActive('Portable App Creator')																;Wait until a new window pops up
			Do
				$PID = WinGetProcess(WinGetTitle(''))																;Get the PID of the new window
			Until Not (ProcessExists('explorer.exe') = $PID * Sleep(100))											;But ignore explorer.exe
			MsgBox(0x42040, 'Portable App Creator', 'Please install the application to your portable device (' & _	;Remind the user!
				$PADrive & ').')
			If ProcessExists($PID) And Not (ProcessExists('ntvdm.exe') = $PID) Then ProcessWaitClose($PID)			;Wait until the Setup has been closed, or continue if it's a 16-bit Setup
			SetButton(True)																							;Set the buttons
		EndIf
		If $Control	= $ButtonArray[3]								Then											;If 'Get ShortCut Info' is clicked
			GetShortCutInfo()																						;Go to GetShortCutInfo()
			SetButton(True)																							;Set the buttons
		EndIf
		If $Control = $ButtonArray[4]								Then											;If 'Open / Close' is clicked
			SetButton(False)																						;Set the buttons
			$PID = Run($ApplicationValue)																			;Run the application
			WinWaitNotActive('Portable App Creator')																;Wait until a new window pops up
			MsgBox(0x42040, 'Portable App Creator', 'Please make all modifications you want to the application' & _	;Remind the user!
				@CRLF & 'and close it to continue.', 10)
			If ProcessExists($PID) Then ProcessWaitClose($PID)														;Wait until the application has been closed
			SetButton(True)																							;Set the buttons
		EndIf
		If $Control = $ButtonArray[5]								Then											;If 'Take 2nd Shot' is clicked
			SetButton(False)																						;Set the buttons
			ControlSend($RegShotTitle, '', 1004, '2s')																;Gets second shot of the registry and files
			Do
			Until ControlCommand($RegShotTitle, '', 1005, 'IsEnabled') * Sleep(100)									;Until the 'compare' button is enabled
			SetButton(True)																							;Set the buttons
		EndIf
		If $Control = $ButtonArray[6]								Then											;If 'Process Shots' is clicked
			SetButton(False)																						;Set the buttons
			ControlSend($RegShotTitle, '', 1005, 'o')																;Compare the two shots
			Do
			Until FileExists($ResFile) * Sleep(100)																	;Continue if the RegShot-results file exists
			AutoItSetOption('WinTitleMatchMode', 2)																	;Change the way AutoIt matches titles of windows
			If WinWait('~res', $RegShotTitle, 20) Then WinClose('~res', $RegShotTitle)								;If the RegShot-results file is opened then close it
			ConvertShots()																							;Go to ConvertShots()
			SetButton(True)																							;Set the buttons
		EndIf
		If WinActive($RegShotTitle)									Then WinActivate('Portable App Creator')		;Don't lose focus to RegShot
	WEnd
EndFunc

Func CreateShortCut()						;CREATES A SHORTCUT TO THE PORTABLE APP
	ClearGUI('Create ShortCut')																						;Clears the GUI and sets the new title
	GUICtrlDelete		($Back)																						;Delete Back
	GUICtrlDelete		($Next)																						;Delete Next
	GUICtrlDelete		($Skip)																						;Delete Skip
	GUICtrlSetData		($Cancel, 'Done')																			;Change text on Cancel
	GUICtrlSetState		($Cancel, $GUI_DISABLE)																		;Disable Cancel
	$ApplicationDrive	= 'PA'																						;Sets the ApplicationDrive to PA
	$ApplicationArray	= StringSplit($ApplicationValue, '\')														;Converts the InputApplicationValue to an array
	$ApplicationFile	= $ApplicationArray[$ApplicationArray[0]]													;ApplicationFile is the last part of the array
	If $ApplicationArray[0] = 2 Then																				;If ApplicationFile is in the root of the drive
		$ApplicationFolder = ''																						;Then Applicationfolder is an empty string
	Else
		$ApplicationFolder = $ApplicationArray[2]
		For $i			= 3 to $ApplicationArray[0] - 1
			$ApplicationFolder &= '\' & $ApplicationArray[$i]														;Else ApplicationFolder is the middel part of the array
		Next
	EndIf
	GUICtrlCreateLabel('Creating the folder on the portable device.',	150, 13, 280, 13)							;Show line of text
	GUICtrlCreateLabel('Compiling the shortcut to the Portable App.',	150, 26, 280, 13)							;Show line of text
	ShellExecuteWait($Temp & '\aut2exe.exe', '/in "' & $Temp & '\portable app shortcut.au3" /out "' & _				;Compile the executable which will be the portable app
		$LauncherValue & '" /icon "' & $SelectedIcon & '" /comp 4')
	FileWrite($IniFile, '[application]' & @CRLF & 'Drive' & @Tab & '=' & @Tab & $ApplicationDrive & @CRLF & _ 		;Write inifile for the portable app
		'Folder' & @Tab & '=' & @Tab & $ApplicationFolder & @CRLF & 'File' & @Tab & '=' & @Tab & $ApplicationFile)
	GUICtrlCreateLabel	('Copying the ini-file for the Portable App.',		150, 39, 280, 13)						;Show line of text
	FileCopy			($IniFile,	$Temp & '\Data\' & $LauncherName & '.ini',	8)									;Copy the ini-file to the temporary data folder
	GUICtrlCreateLabel	('Copying the reg-file for the Portable App.', 		150, 52, 280, 13)						;Show line of text
	FileCopy			($RegFile,	$Temp & '\Data\' & $LauncherName & '.reg',	8)									;Copy the reg-file to the temporary data folder										
	GUICtrlCreateLabel	('Copying the lst-file for the Portable App.',		150, 65, 280, 13)						;Show line of text
	FileCopy			($LstFile,	$Temp & '\Data\' & $LauncherName & '.lst',	8)									;Copy the lst-file to the temporary data folder
	GUICtrlCreateLabel	('Copying all files to the portable device.',	150, 78, 280, 13)							;Show line of text
	DirCopy				($Temp & '\Data', $LauncherFolder & '\Data', 1)												;Copy the data folder to the portable app folder
	If $CompressApp Then
		GUICtrlCreateLabel	('Compressing the Portable App using UPX.',		150, 91, 280, 13)						;Show line of text
		FileWriteLine($Temp & '\UPXInfo.txt', $PADrive & '\' & $ApplicationFolder)
		RunWait(@ComSpec & ' /c dir /ad /b /s "' & $PADrive & '\' & $ApplicationFolder & '" >>UPXInfo.txt', $Temp, _;Get the list of all subfolders under the Application folder
			@SW_HIDE)
		RunWait(@ComSpec & ' /c dir /ad /b /s "' & $LauncherFolder  & '\data'		   & '" >>UPXInfo.txt', $Temp, _;Get the list of all subfolders under the data folder
			@SW_HIDE)
		$FileLines			= FileCountLines($Temp & '\UPXInfo.txt')												;Count the number of lines
		For $LineNumber		= 1 to $FileLines
			ShellExecuteWait($Temp & '\upx.exe', '--best *.*', FileReadLine($Temp & '\UPXInfo.txt', $LineNumber), _	;UPX all files in the given folder
				'open', @SW_HIDE)
		Next
	EndIf
	GUICtrlCreateLabel	('Done creating the Portable App ' & $LauncherName & '.', 150, 117, 280, 26)				;Show line(s) of text
	GUICtrlSetState		($Cancel, $GUI_ENABLE_DEFBUTTON)															;Enable Cancel and give it focus
	While 1
		$Control = GUIGetMsg()																						;Get info from the GUI
		If $Control = $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed, then exit the script
	WEnd
EndFunc

Func RegShotError()								;DISPLAY ERROR FOR VISTA WITH UAC ENABLED AND/OR A 64-BIT OS
	ClearGUI('RegShot Error')																						;Clears the GUI and sets the new title
	If StringRight(@ProcessorArch, 2) = '64' Then																	;Running a 64-bit OS / Mental note: @ProcessorArch actually gives the architecture of the OS!
		GUICtrlCreateLabel	('Portable App Creator (PAC) detected that you are running a 64-bit operating ' & _		;Show lines of text
			'system on your computer. PAC uses a helper program (RegShot) which is not compatible with 64-bit operating systems. Therefore PAC will now quit.',  150, 13, 280, 52)
	Else																											;Running Vista with UAC enabled
		GUICtrlCreateLabel	('Portable App Creator (PAC) detected that you are running Microsoft Vista and ' & _	;Show lines of text
			'User Account Control (UAC) is enabled. PAC uses a helper program (RegShot) which will not work on your system unless you (temporary) disable UAC.', 150, 13, 280, 52)
		GUICtrlSetFont		(GUICtrlCreateLabel('Please disable UAC and restart Portable App Creator.', 150, 78, _	;Show line of bold text
			280, 26), -1, 800)
	EndIf
	GUICtrlSetColor		(-1, 0xff0000)																				;Make the font red
	GUICtrlDelete		($Back)																						;Delete Back
	GUICtrlDelete		($Next)																						;Delete Next
	GUICtrlDelete		($Skip)																						;Delete Skip
	GUICtrlSetData		($Cancel, 'Exit')																			;Change text on Cancel
	While 1
		$Control = GUIGetMsg()																						;Get info from the GUI
		If $Control = $GUI_EVENT_CLOSE or $Control = $Cancel		Then Exit										;If the GUI is closed, then exit the script
	WEnd
EndFunc

Func SetButton($NextStep)					;SETS THE BUTTONS ON THE MONITORINSTALLATION-WINDOW
	If $CurrentButton = 2 Or $CurrentButton > 3						Then GUICtrlSetState ($Back, $GUI_DISABLE)		;Disable BackButton if the installation took place, except to go back to the shortcutinfo
	If $NextStep													Then											;If NextStep is true
		$CurrentButton += 1																							;Set a new CurrentButton
		For $i = 1 to $ButtonArray[0]
			If $i <  $CurrentButton	Then GUICtrlSetData	($ButtonArray[$i], 'Done')									;Rename all previous buttons
			If $i <> $CurrentButton	Then GUICtrlSetState($ButtonArray[$i], $GUI_DISABLE)							;Disable all buttons but the CurrentButton
			If $i =	 $CurrentButton Then GUICtrlSetState($ButtonArray[$CurrentButton], $GUI_ENABLE)					;Enable the CurrentButton
		Next
		GUICtrlSetState	($Next, $GUI_ENABLE_DEFBUTTON)																;Enable Next and give it focus
	Else																											;If NextStep is false
		GUICtrlSetState	($Next, 						$GUI_DISABLE)												;Disable Next
		GUICtrlSetState	($ButtonArray[$CurrentButton],	$GUI_DISABLE)												;Disable the CurrentButton
		GUICtrlSetData	($ButtonArray[$CurrentButton],	'Working...')												;Rename the CurrentButton
	EndIf
EndFunc

Func ConvertShots()							;CONVERT THE REGSHOT RESULT FILE
	$FileLines			= FileCountLines($ResFile)																	;Count the number of lines in $ResFile
	For $LineNumber		= 1 to $FileLines	;PROCESS THE ADDED REGISTRY KEYS
		If StringLeft(FileReadLine($ResFile, $LineNumber), 13) = 'Values added:' Then ExitLoop						;Continue if 'Values added:' was found in the $ResFile
	Next
	For $LineNumber		= $LineNumber + 2 to $FileLines																;Investigate the lines after 'Values added:', if they exist
		$RegKey			= StringSplit(FileReadLine($ResFile, $LineNumber), ': ', 1)									;Split the line read using ': '
		If Not 		  	  $RegKey[1] Then ExitLoop																	;Stop this part if the line is empty
		$RegKey			= StringSplit($RegKey[1], '\')																;Split the string using '\'	
		$KeyName		= $RegKey[1]																				;Get the root of the registry
		For $i 			= 2 to $RegKey[0] - 1
			If $i		= 2  And $KeyName = 'HKU' Then																;Replace HKU\[...]\ with HKCU\ if needed
				$KeyName = 'HKCU'
			Else
				$KeyName &= '\' & $RegKey[$i]																		;Build the keyname	
			EndIf
		Next
		For $CheckRegKey = 1 to $SkipRegKey[0]
			If StringInStr($KeyName, $SkipRegKey[$CheckRegKey]) Then ContinueLoop(2)								;If the RegKey is unnecessary (part of SkipRegKey) ContinueLoop
		Next
		$ValueName		= $RegKey[$RegKey[0]]																		;Get the valuename
		$Value			= RegRead($KeyName, $ValueName)																;Get the value
		$Type			= $RegTypes[@extended]																		;Get the type of the value
		$Value 			= StringReplace(StringReplace($Value, $PADrive, 'PA:'), @lf, '@lf')							;Replace the linefeed character and PA-drive
		$Value			= StringReplace($Value, @lf, '@lf')															;Replace the linefeed character
		For	$i			= 1 to $EnvArray[0]																			;Find out if the value points to an 'environment variable'
			If StringInStr($Value, $EnvGetAr[$i]) Then Exitloop														;If so then exitloop
			If $i = $EnvArray[0] Then $Value = StringReplace($Value, $PADrive, 'PA:')								;Else replace the PA-drive
		Next
		FileWriteLine($RegFile, $KeyName & ', ' & $ValueName & ', ' & $Type & ', ' & $Value)						;Write a line in $RegFile containing the registy-information
	Next
	For $LineNumber		= 1 to $FileLines	;PROCESS THE ADDED FILES
		If StringLeft(FileReadLine($ResFile, $LineNumber), 12) = 'Files added:' Then ExitLoop						;Continue if 'Files added:' was found in the $ResFile
	Next
	For $LineNumber		= $LineNumber + 2 to $FileLines																;Investigate the lines after 'Files added:', if they exist
		$LineText		= FileReadLine($ResFile, $LineNumber)														;Read the line
		If Not $LineText Then ExitLoop																				;Stop this part if the line is empty
		For $CheckFolder = 1 to $SkipFolder[0]
			If StringInStr($LineText, $SkipFolder[$CheckFolder]) Then ContinueLoop(2)								;If the Folder is unnecessary (part of SkipFolder) ContinueLoop
		Next
		For $i 			= 1 to $EnvArray[0]
			If StringInStr($LineText, $EnvGetAr[$i]) Then ExitLoop													;See to which 'environment variable'-folder the line actually directs to
		Next
		$PAFFileName = StringReplace($LineText, $EnvGetAr[$i], $EnvArray[$i], 1)									;Replace the first part of the filename with that of the environment variable
		FileCopy($LineText, $Temp & '\Data\' & $PAFFileName, 8)														;Copy the file to the data-folder
		FileWriteLine($LstFile, $PAFFileName)																		;Write a line in $LstFile containing the file-information
	Next
EndFunc

Func InstallHelperFiles()					;INSTALLS ALL NECESSARY FILES FOR THIS SCRIPT
	$TempInfo = DirGetSize($Temp, 1)
	If $TempInfo[1] = 3 Then																						;If $Temp only has 3 files then
		FileInstall('portable app shortcut.au3',					$Temp & '\')
		FileInstall('..\..\app\appfiles\regshot.exe', 				$Temp & '\')
		FileInstall('..\..\app\appfiles\aut2exe.exe',				$Temp & '\')
		FileInstall('..\..\app\appfiles\AutoItSC.bin',				$Temp & '\')
		FileInstall('..\..\app\appfiles\upx.exe',					$Temp & '\')
		FileInstall('..\..\app\appinfo\portable app creator.ico',	$Temp & '\')
		$ExtDir = $EnvGetAr[1]
		For $i = 2 to $EnvArray[0]
			$ExtDir &= ';' & $EnvGetAr[$i]
		Next
		FileWrite($RegShotIni, '[setup]' & @CRLF & 'flag=3' & @CRLF & 'extdir=' & $ExtDir & @CRLF & 'outdir=' & _	;Writing RegShot.ini
			$Temp)
		ProcessSetPriority(Run($Temp & '\regshot.exe', $Temp, @SW_HIDE), 0)											;Execute RegShot and set the priority to 'low'
		If WinWait($RegShotTitle) Then $RegShotTitle = WinGetTitle($RegShotTitle)									;Wait for the RegShot window and get its (full) title
		WinActivate('Portable App Creator')
		GUICtrlSetTip($InfoTip, 'version: '	& @TAB & '|VERSION|' & @CRLF & 'compiled:' & @TAB & $CompileDate[2] & '-' & $CompileDate[1] & '-' & $CompileDate[0] & @CRLF & 'system:  ' & @TAB & 'Windows ' & $OSVersion, 'Portable App Creator', 1, 1)	
	EndIf
EndFunc

Func ClosePAC()								;NEEDED TO DEFINE AN ACTION FOR THE CANCEL BUTTON
	ProcessClose('regshot.exe')	
	DirRemove($Temp, 1)
EndFunc

Func FileCountLines($File)					;GET THE NUMBER OF LINES FOR A CERTAIN FILE
	Local $N = FileGetSize($File) - 1
	Return StringLen(StringAddCR(FileRead($File, $N))) - $N + 1
EndFunc

Func Help()									;EXECUTES README IF IT EXISTS
	If FileExists(@ScriptDir & '\readme.pdf') Then ShellExecute(@ScriptDir & '\readme.pdf')
EndFunc

Func FirstIconToFile($SourceFile,$IconFile) ;Credits for the next three functions go to Smashly (http://www.autoitscript.com/forum/index.php?showtopic=74565). Allthough I made some adaptions / simplifications myself...
	Global	$FileHandle = DllCall('kernel32.dll', 'hwnd', 'LoadLibraryExA', 'str', $SourceFile, 'hwnd', 0, 'int', 0x00000002)
						  DllCall('kernel32.dll', 'int', 'EnumResourceNamesW', 'ptr', $FileHandle[0], 'int', 14, 'ptr', DllCallbackGetPtr(DllCallbackRegister('_EnumResNameProc', 'int', 'int_ptr;int_ptr;int_ptr;int_ptr')), 'ptr', 0)
						  If UBound($aEN) = 1 Then Return(False)
	$FindHandle			= DllCall('kernel32.dll', 'int', 'FindResourceA', 'int', $FileHandle[0], 'str', $aEN[1], 'long', 14)
	$SizeArray			= DllCall('kernel32.dll', 'dword', 'SizeofResource', 'int', $FileHandle[0], 'int', $FindHandle[0])
	$ResourceHandle		= DllCall('kernel32.dll', 'int', 'LoadResource', 'int', $FileHandle[0], 'int', $FindHandle[0])
	$DataString 		= DllStructGetData(DllStructCreate('byte[' & $SizeArray[0] & ']', $ResourceHandle[0]), 1)
	$HeaderString 		= BinaryMid($DataString, 1, 6)
	$HeaderArray		= StringRegExp(StringTrimLeft(BinaryMid($DataString, 7), 2), '(.{28})', 3)
	$Offset				= (UBound($HeaderArray)* 16) + 6
	For $i = 0 To UBound($HeaderArray) - 1
		$HeaderString  &= StringTrimRight($HeaderArray[$i], 4) & _ReverseHex(Hex($Offset))
		$Offset		   += Dec(_ReverseHex(StringMid($HeaderArray[$i], 17, 8)))
	Next
	For $i = 0 To UBound($HeaderArray) - 1
		$FindHandle		= DllCall('kernel32.dll', 'int', 'FindResourceA', 'int', $FileHandle[0], 'str', '#' & Dec(_ReverseHex(StringRight($HeaderArray[$i], 4))), 'long', 3)
		$SizeArray		= DllCall('kernel32.dll', 'dword', 'SizeofResource', 'int', $FileHandle[0], 'int', $FindHandle[0])
		$ResourceHandle = DllCall('kernel32.dll', 'int', 'LoadResource', 'int', $FileHandle[0], 'int', $FindHandle[0])
		$HeaderString  &= StringTrimLeft(DllStructGetData(DllStructCreate('byte[' & $SizeArray[0] & ']', $ResourceHandle[0]), 1), 2)
	Next
	$IconFileHandle = FileOpen($IconFile, 18)
	FileWrite($IconFileHandle, $HeaderString)
	FileClose($IconFileHandle)
	ReDim $aEN[1]
	DllCall('Kernel32.dll', 'hwnd', 'FreeLibrary', 'hwnd', $FileHandle)
	Return(True)
EndFunc

Func _ReverseHex($Byte)
	Return(StringMid($Byte, 7, 2) & StringMid($Byte, 5, 2) & StringMid($Byte, 3, 2) & StringMid($Byte, 1, 2))
EndFunc

Func _EnumResNameProc($hModule, $pType, $pName, $lParam)
	Local $aSize = DllCall('kernel32.dll', 'int', 'GlobalSize', 'ptr', $pName), $tBuf
	If $aSize[0] Then
		$tBuf = DllStructCreate('wchar[' & $aSize[0] & ']', $pName)
		ReDim $aEN[UBound($aEN) + 1]
		$aEN[0] += 1
		$aEN[UBound($aEN) - 1] = DllStructGetData($tBuf, 1)
	Else
		ReDim $aEN[UBound($aEN) + 1]
		$aEN[0] += 1
		$aEN[UBound($aEN) - 1] = "#" & $pName
	EndIf
EndFunc